function vk = vkvantil(x, p)
% VKVANTIL  vyberovy kvantil (nahrada funkcie 'prctile')
%      vk = vkvantil(x, p)
% argin :   x = vstupny subor - vektor dat
%           p = cislo z intervalu (0, 1)
% argout:   vk= vyberovy p-kvantil suboru x
%
if ( (p <= 0)|(p >= 1) )
    error('chyba na vstupe!')
    return
end
n = length(x);
xx = sort(x);                       
yy = 1/(2*n) : 1/n : (1 - 1/(2*n));	
%
u = 1/(2*n);
v = 1 - 1/(2*n);
if p < u, p = u; end
if p > v, p = v; end
vk = interp1(yy, xx, p);
