from django.http import HttpResponse
from django.template import Context,Template,loader

def chyba(text):

    t=loader.get_template("chyba.html")
    c=Context({'chyba':text})
    return HttpResponse(t.render(c))

class Dvojica(object):

    def __init__(self,n,hodnota):
        self.n = n
        self.hodnota = hodnota


def nasobky(request,cislo):

    zoz_nasobkov=[]
    # cislo je retazec
    # musime ho previest na int
    # treba kontrolovat vstup uzivatela! 
    try:
        cislo_int=int(cislo)
    except ValueError:
        return chyba("%s sa nepodarilo previest na cislo" % cislo)
    if cislo_int<0:
        return chyba("cislo %d je zaporne" % cislo_int)
    for i in range(11):
        zoz_nasobkov.append(Dvojica(i,i*cislo_int))
    c=Context({'cislo':cislo_int,'vysledky':zoz_nasobkov})
    t=loader.get_template("nasobky.html")
    return HttpResponse(t.render(c))

# Predosla a nasledujuca funkcia
# obsahuju zjavne duplicitny kod.
# To je bezzasadove, ale nechcem veci komplikovat.


def delitele(request,cislo):
    
    zoz_delitelov=[]
    # cislo je retazec
    # musime ho previest na int
    # treba kontrolovat vstup uzivatela! 
    try:
        cislo_int=int(cislo)
    except ValueError:
        return chyba("%s sa nepodarilo previest na cislo" % cislo)
    if cislo_int<0:
        return chyba("cislo %d je zaporne" % cislo_int)
    pocitadlo=0
    for i in range(1,cislo_int+1):
        if (cislo_int % i)==0:
            pocitadlo+=1
            zoz_delitelov.append(Dvojica(pocitadlo,i))
    c=Context({'cislo':cislo_int,'vysledky':zoz_delitelov})
    t=loader.get_template("delitele.html")
    return HttpResponse(t.render(c))

