# -*- coding: utf-8 -*-
from django import forms
from django.shortcuts import render_to_response

class MathOpForm(forms.Form):
    operand1=forms.IntegerField(required=True)
    operand2=forms.IntegerField(required=True)
    operation=forms.ChoiceField(choices=[('+','+'),('-','-'),('*','*')],required=True)


__oper_map={'+':'__add__','-':'__sub__','*':'__mul__'}

def math_form(request):

    global __oper_map

    if request.method=='POST':
        form=MathOpForm(request.POST)
        # form.is_valid() skontroluje,
        # ci su udaje vo formulari v poriadku
        if form.is_valid():
            # Vzhladom na to, ze form.is_valid() je True,
            # mozeme tu uz predpokladat, ze data su v poriadku.
            
            # slovnik cleaned_data uz obsahuje *cisla* ako operandy
            operand1=form.cleaned_data['operand1']
            operand2=form.cleaned_data['operand2']
            # operation je retazec
            operation=form.cleaned_data['operation']

            # Trochu pythonovskeho voodoo:
            # * operation je jedna z '+','-','*'
            # * __oper_map je globalna premenna tohto modulu typu slovnik (vid hore)
            # * __oper_map['+'] je napr. retazec '__add__'
            # * operand1 je typu int
            # * getattr(operand1,'__add__') vrati viazanu metodu z namespace
            #   toho objektu typu int
            # * tejto metode je poslany operand2_int
            #
            # Skuste si na pythonovskom prompte:
            # 1.__add__
            # 1.__add__(2)
            # getattr(1,'__add__')
            # getattr(1,'__add__')(2)
            if not (operation in __oper_map):
                # Sem sa nikdy nedostaneme, to zabezpeci .is_valid
                # Ale istota je istota
                return(render_to_response("chyba.html",
                    {'chyba':u"Neznáma operácia"}))
            vysledok=getattr(operand1,__oper_map[operation])(operand2)
            return(render_to_response("vysledok.html",
                {'operand1':operand1,
                 'operand2':operand2,
                 'operation':operation,
                 'vysledok':vysledok}))
    else: 
        form=MathOpForm()
    # Sem sa dostaneme v dvoch pripadoch
    # 1) request.method nie je 'POST', teda je to takmer iste 'GET'
    #    v tom pripade sa vykonalo form=MathOpForm(), a teda formular
    #    je prazdny.
    # 2) form.is_valid() vratilo False, v tom pripade je form zkonstruovany
    #    z POST requestu s vyznacenymi chybami.
    return(render_to_response("form.html",{'form':form}))
