function A = genmat(m,n,a,b)
% GENMAT     generuje maticu A [m,n], pricom A(i,j) su RAND z (a, b)
% A = genmat(m,n,a,b)
%
% GENMAT(m)  generuje stvorcovu [m,m] pricom A(i,j)= RAND
% GENMAT(m,n)  generuje [m,n], ked A(i,j) = RAND
% GENMAT(m,n,a)  generuje [m,n], ked A(i,j) su RAND z (-a, a)
% GENMAT(m,n,a,b)  generuje [m,n], ked A(i,j) su RAND z (a, b), pricom a ~= b
%
if nargin < 2
   A = rand(m,m); 
elseif nargin < 3
   A = rand(m,n); 
elseif nargin < 4
   A = 2*a*rand(m,n) - a; 
elseif a == b
   disp('chybny vstup, interval ma nulovu dlzku')
   return
elseif a > b
   t = a; a = b; b = t;
   A = (b - a)*rand(m,n) + a;
else
   A = (b - a)*rand(m,n) + a;
end

