%
% eXperimentovanie s prikazom(resp. funkciou)  FPRINTF
%
echo on
% ***********************************************************
%
% **  x_printf = zjednoduseny vyklad  a  eXperimentovanie  **
%
% berte na vedomie, ze vyklad je zjednoduseny ...
% 
% syntax:  fprintf(retazec definujuci format, zoznam vyrazov)
%
% -----------------------------------------------------------
pause
% nasledujuci riadok sluzi na "odpocitavanie" pozicii
% 345678901234567890
%
fprintf('%10.3f \n', 1000*pi)

%
% Odpocitanie zlava doprava hovori, ze umiestnenie hodnoty
% vyrazu bolo pouzitych 10 miest, pricom do tych 10 sa rata
% aj miesto pre desatinnu bodku a ked treba, aj na znamienko
% minus  "-" . 
% Tri miesta (z tych 10) boli pouzite na desatinnu cast, ktora
% teraz, ako vieme, ma nekonecny desatinny rozvoj.
% Preverme, ze je to tak:
% 3456789012345
fprintf('%15.5f \n', -1000*pi)

pause
%
% Podme (experimentovanim) zistit, ci odozva "fprintf" zavisi
% od aktualneho formatu:
% Zmenme format na "long"
%
format long
%
% 3456789012345
fprintf('%15.5f \n', -1000*pi)

% zda sa, ze nie ...
pause
%
% Teraz skusme, ci je mozne info stratit ...
% Zvolme volanie takto:
% 3456789012345

fprintf('%15.15f \n', -1000*pi)
%
pause
%
% vratme sa ku "default" formatu  "short", prikazom format
% 

format
%
fprintf('%15.15f \n', -1000*pi)


% vidime dve veci: odozva nesuvisi s aktualnym formatom
%                  f v specifikacii znamena notaciu "fixed point"

pause
%
% pre exponencialnu notaciu pouzijeme "e"
%
fprintf('%15.15e \n', -1000*pi)

% pre integer pouzijeme "d"
%
iter = 27; fprintf('%4.0d \n', iter)

pause
%
% Ak chceme aj s textom, tak takto:
%
fprintf('pocet iteracii = %2.0d \n', iter)

%
a = 10; b = 20; 
fprintf('strany maju rozmery: %2.0d , resp. %2.0d\n',a,b)


pause
%
% alebo pouzijeme "\n", ak chceme druhu polozku do dalsieho riadku:
%
fprintf('strany maju rozmery: %2.0d , resp. \n %22.0d\n',a,b)

pause
%
% na formatovanie vypisov pozri: 

% ver. ML6
% help na: disp, fprintf, sprintf, num2str, int2str
% pozri Help, resp. pouzi: doc *,  teda  doc fprintf, atd.
% diary off
