function [an, bn] = polovica(mf, a, b)
% POLOVICA   vrati tu "polovicu" intervalu [a, b], ktora obsahuje koren
% je to len pomcka na osvojenie algoritmu metody  "bisekcia intervalu"
%
% [an, bn] = polovica(mf, a, b)
%
% argin : mf - meno funkcie (retazec)
%         a  - lavy okraj intervalu
%         b  - pravy okraj intervalu
% argout: an - anove 
%         bn - bnove, pricom [an, bn] je ta polovica intervalu [a, b]
%                     ktora obsahuje koren
%
fa = feval(mf, a);
fb = feval(mf, b);
if fa*fb >= 0
   disp(' ');
   error('chybny vstup, lebo f(a)*f(b) >= 0'), return
end
x = (a + b)/2;
fx = feval(mf, x);
if fx == 0
   disp(' ');
   disp('v strede intervalu [a, b] sa f rovna nule!');
   an = x; bn = x;
   return
end
if fa*fx < 0
   an = a;
   bn = x;
else
   an = x;
   bn = b;
end
