function [x,iter] = bisekcia2(mf,a,b,epsilon)
% BISEKCIA2 metoda bisekcie intervalu pre f(x) = 0.
% [x,iter] = bisekcia2(mf,a,b,epsilon)
%
% argin : mf je meno(retazec) funkcie f(.) [lavej strany rovnice f(x) = 0]
%         a,b take, aby f(a).f(b) < 0  t.j. v (a, b) je znamienkova zmena
%
% argout: x    = aproximacia korena "alfa", pricom |x - alfa|< epsilon
%         iter = pocet deleni (pocet iteracii)
% 
% *pozn.: ak vstupne "epsilon" je mensie ako eps*abs(b), tak cyklus while
%         sa moze stat "nekonecnym"! (Ctrl_C)
%
fa = feval(mf,a);
fb = feval(mf,b);
disp(' ');

if fa*fb >= 0
   disp('Chybny vstup! Pre vstupny interval neplati f(a)*f(b)< 0')
   return
end

if nargin < 4
   epsilon = eps*abs(b);
end

iter = 0;
while b-a > epsilon
   x = (a+b)/2;
   iter = iter + 1;
   fx = feval(mf,x);    
   if fx == 0
      disp(sprintf(' pre x =%19.16f je f(x) = 0 ', x))
      disp(sprintf(' pocet iteracii = %2d',iter))
      disp(' --------------------------------------')
      return
   end
   if fa*fx < 0
      % koren lezi v (a, x)
      b  = x; 
      fb = fx;
   else
      % koren lezi v (x, b)
      a  = x; 
      fa = fx;
   end  
end
