%  SCRIPT " x_plot" 
%
%  SCRIPT:  Volania funkcii  EZPLOT,  FPLOT
%
%  --------------------------------------------
%   
%  Zacneme s funkciou  EZPLOT
%
%  (1) built-in  funkciu volame menom (retazcom)
%
close all, clc
echo on
figure(1), ezplot( 'sin', [0, 6*pi] )
%
pause
%
% avsak ak chceme f(x)= x.sin(5x)  tak takto 
%
figure(2), ezplot( 'x*sin(5*x)' ,  [0, pi] )
%
pause
%
% VYSKUSAJTE vektorove volanie:
%
% ezplot( 'x.*sin(5*x)', [0, pi] ) 
%
% poucenie: "ezplot" neziada nutne vektorovu definiciu
% ----------------------------------------------------
pause
%
% (2) ak chceme s takouto funkciou pracovat viac
%     razy, mozeme ju definovat ako  INLINE objekt
%
f =  inline( 'x.*sin(5*x)' )
%
pause
%
% funkcia ma meno f (ako objekt), volanie ma tvar
%
figure(3), ezplot( f, [0, 4*pi] )
%
pause
% -----------------------------------------------
%
% (3) nech funkcia je definovana ako M-funkcia 
%     (in file)
%     vyskusajte ponukane funkcie "f1", "f1v"
%
%  figure(4), ezplot('f1', [0, 3*pi] )   % tento prikaz
%
%  sposobi chybove hlasenie! Definicia tentoraz musi byt
%  vektorova (lebo funkcia je definovana v subore).
%
figure(5), ezplot('f1v', [0, 3*pi] )
pause
close all
% ===============================================
clc
%
% Teraz je na rade funkcia  FPLOT
%
% (1) built-in  funkciu volame menom (retazcom) 
%
figure(1), fplot( 'cos', [-4*pi, 4*pi] )
%
pause
%
% je mozne pracovat s kompoziciou built-in funkcii:
%
figure(2), fplot( 'sqrt(cos(x.^2) + 2)', [0, 2*pi])
%
pause
%
% ----------------------------------------------
%
% (2) ak chceme s takouto  funkciou pracovat viac
%     razy, mozeme ju definovat ako INLINE objekt
%
%     pozn.: FPLOT nevyzaduje vektorovu definiciu
%
g =  inline( 'x*cos(2*x)' )
%
pause
%
figure(3), fplot( g,  [0, 2*pi] )
%
pause
% -----------------------------------------------
%
% (3) nech funkcia je definovana ako M-funkcia
%     (in file)
%
%     pri FPLOT nemusi byt definicia vektorova
% 
figure(4), fplot( 'f1', [0, 3*pi] )
%
pause
%
% ale, samozrejme, moze byt vektorovou:
%
figure(5), fplot( 'f1v', [0, 2*pi] )
%
%  ---------------------------------------------------------------------------------
%  Odporucania:

%  1)  vsimajte si  systemovu  "info o chybe" (error message),
%      aby ste rozpoznali, ze chyba je len v nevektorizovani.

%  2)  zo zaciatku radsej vzdy vektorizujte ...
pause
% diary off

