%  SCRIPT "x_inline"
%  x_inline SCRIPT  (= eXperimentovanie s  " inline "  definovanim funkcii)
%
%  Co dovoluje "inline" definovanie funkcii (vzhladom na parametre)??
%  
%  1)  " inline "  definovanie bez parametra - pouzitie  PLOT,  EZPLOT, FPLOT
%
%  2)  " inline "  definovanie s parametrom - zase  PLOT,  EZPLOT,  FPLOT
%
%  ---------------------------------------------------------------------------
close all
echo on
clc
%
%  Definujme  f  napr. takto:
%
f = inline('x.*(1 + x)')
%
pause
%
x =   0 : 0.2 : 1
%
pause
%
y = f(x)
%
pause
%
figure(1), plot(x, f(x))		% funguje
%
pause
%
figure(2), ezplot(f,  [0, 1])		% funguje
%
pause
%
figure(3), fplot(f,  [0, 1])		% funguje
%
pause
%
%  2)  Teraz  "inline"  definovanie s parametrom:
%
g = inline('x.*(1 + a*x)', 'x','a')
%
%  x je premenna, a  je parameter 
%  (tak chceme chapat symboly x, resp. a)
%
%  definujme hodnotu parametra
%
a =  2
%
pause
%
y =  g(x, a)
%
pause
%
%  takze k hodnotam  g(x, a)  pre  a = 2   sme sa dostali volanim  y = g(x, a) !
%  ak toto funguje, bude fungovat PLOT - overme:
%
pause
%
figure(4), plot(x,  g(x, a))
%
%  OK.
%
pause
%
%  teraz to skusme s  FPLOT,  EZPLOT
%
figure(5), fplot( g , [0, 1])
%
pause
%
figure(6), ezplot( g , [0, 1])
%
% K obrazkom figure(5), figure(6) sme sa nedostali!
% Uvedomte si rozdiel medzi PLOT na jednej strane
% a  EZPLOT, resp. FPLOT  na strane druhej ...
%
% END
% diary off
