echo on
%
%  ********************************************************
%  ***                   POKUS_SIET                     ***
%
%  Pokus s vytvaranim siete uzlov nezavisle premennej. Pred
%  experimentovanim s tymto scriptom, pozri help-lines
%  scriptu  "pokus_arit"   (tam je viac objasnenia... )
%
%  Tento script ilustruje, ze aj ked prikazy na zostrojenie
%  vektora (=siete) hodnot nezavisle premennej (bodov):
%
%     (1)   x = linspace(a,b,n)
%     (2)   t = a:h:b,   kde h = (b-a)/(n-1)
%
%  su (matematicky vzate) ekvivalentne, tak v MATLAB-e,
%  identicky rovnake vysledky ocakavat nemozeme!
%  Preco?
%  Pretoze aritmetika pohyblivej radovej ciarky (bodky),
%  t.j. aritmetika pocitacovej mnoziny cisel F(2,53)
%  nie je zhodna s aritmetikou realnych cisel!
% 
pause
format compact
a = 0; b = 10;
n = 11;
h = (b-a)/(n-1);
x = linspace(a, b, n);
t = a:h:b;
x == t
%
% OK, teraz to vyslo rovnako, ale zmenme  a, b  napr. takto:
pause
a = 0.1; b = 10.2;
h = (b-a)/(n-1);
x2 = linspace(a, b, n);
t2 = a:h:b;
x2 == t2
%
% Teraz situacia ilustruje:
%
% Matematicky ekvivalentne postupy nemusia davat rovnaky vysledok!!
% *****************************************************************
echo off
% zmente n na hodnotu 21, resp. experimentujte