echo on
%
%  ********************************************************
%  ***   POKUS_ARIT ( = pokus s aritmetikou MATLABu )   ***
%  
%  Tento script ilustruje, ze dobre zname zakony aritmetiky
%  neplatia v mnozine pocitacovych cisel MATLABu (IEEE-1985)
%  Majme na zreteli, ze informaciu o tom, ci dve cisla su
%  pre MATLAB rovnake, alebo nie su, nedava obrazovka, ale
%  odozva relacneho operatora "==".
%
%  Odozvou "a == b" je 1, ak sa (pre ML)  a  rovna  b,
%                      0, ak sa (pre ML)  a nerovna b.
%
%  O reprezentacii cisla v ML, pozri skripta, str.35.
%  (symbol '=' v MATLABe znamena priradovaci prikaz!)
%
%  Pred spustenim scriptu sa zamyslite nad jeho obsahom, 
%  t.j. preskumajte jeho zdrojovy tvar. 
%  -------------------------------------------------------
%  Pre pokracovanie plati zname "press any key to continue"
%
pause
echo off, warning off, 
format long e, format compact
n = 10;
for i = 1:n,
    a = rand; b = rand; c = rand;
    s(i)= ( (a*b)/c == a*(b/c) );
    if s(i) == 0
        LS = (a*b)/c     %  lava strana
        PS = a*(b/c)     % prava strana
        disp('-------------------------- ')
    end
end
disp('Niekedy aj display ukazuje, ze LS je ina hodnota ako PS.');
disp('Ak ste sa nedockali ziadneho vypisu, spustite script este raz!');
disp('Mozete, samozrejme, zva:csit n (= pocet "pokusov").');
%
% Poznamka pre tych, ktori maju zaujem:
% riadok
% s(i)= ( (a*b)/c == a*(b/c) );
%
% nahradte napr. overenim distributivneho zakona
% s(i)= ( a*(b + c) == a*b + a*c ); 
%
% experimentujte dalej...;-)