echo on
% --------------------------------------------------------------------->
% tento script ilustruje, ze matematicky ekvivalentne postupy
% nedavaju pri realnych vypoctoch rovnake vysledky
%
% Preskumame tri sposoby evaluovania polynomu.
% Prvy je (z vypoctovej stranky) najhorsi!
%
% Funkcia je nazvana "polyvyraz" a evaluuje polynom algoritmom
% z 1.prednasky:
%
% Algoritmus #1 (pracuje s mocninami)
%
% znazornime hodnoty polynomu p = [1  -7  21  -35  35  -21  7  -1]
% na intervale [0.985  1.015]
%
pause
%
x = 0.985:0.001:1.015;
%
figure(1), plot(x, polyvyraz(p, x))
pause
% 
% --------------------------------------------------------------------
% teraz budeme pracovat s lepsim algoritmom: s Hornerovym algoritmom
%
pause
figure(2), plot(x, polyhorner(p, x))
pause
%
% OK, vidime, polyhorner dava vernejsi graf!
%
% --------------------------------------------------------------------
% V tomto specialnom pripade od Hornera je lepsi vycislovaci postup,
% ktory pouziva "odhalenie" ze nas polynom = (x - 1)^7
% sa da vycislit jedinou mocninou!
%
pause
figure(3), plot(x, (x - 1).^7)
%
diary off
